/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.database.interpret;

import com.mckoi.database.DatabaseConnection;
import com.mckoi.database.DatabaseException;
import com.mckoi.database.ExpressionPreparer;
import com.mckoi.database.ParameterSubstitution;
import com.mckoi.database.StatementCache;
import com.mckoi.database.StatementTree;
import com.mckoi.database.TObject;
import com.mckoi.database.Table;
import com.mckoi.database.TransactionException;
import com.mckoi.database.interpret.Statement;
import com.mckoi.database.jdbc.SQLQuery;
import com.mckoi.database.sql.ParseException;
import com.mckoi.database.sql.SQL;
import java.io.StringReader;
import java.sql.SQLException;

public class SQLQueryExecutor {
    private static SQL sql_parser = new SQL(new StringReader(""));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table execute(DatabaseConnection connection, SQLQuery query) throws SQLException, DatabaseException, TransactionException, ParseException {
        Statement statement;
        String query_str = query.getQuery();
        StatementTree statement_tree = null;
        StatementCache statement_cache = connection.getSystem().getStatementCache();
        if (statement_cache != null) {
            statement_tree = statement_cache.get(query_str);
        }
        if (statement_tree == null) {
            SQL sQL = sql_parser;
            synchronized (sQL) {
                sql_parser.ReInit(new StringReader(query_str));
                sql_parser.reset();
                statement_tree = sql_parser.Statement();
            }
            if (statement_cache != null) {
                statement_cache.put(query_str, statement_tree);
            }
        }
        final Object[] vars = query.getVars();
        ExpressionPreparer preparer = new ExpressionPreparer(){

            public boolean canPrepare(Object element) {
                return element instanceof ParameterSubstitution;
            }

            public Object prepare(Object element) {
                ParameterSubstitution ps = (ParameterSubstitution)element;
                int param_id = ps.getID();
                return TObject.objectVal(vars[param_id]);
            }
        };
        statement_tree.prepareAllExpressions(preparer);
        String statement_class = statement_tree.getClassName();
        try {
            Class<?> c = Class.forName(statement_class);
            statement = (Statement)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("Could not find statement class: " + statement_class);
        }
        catch (InstantiationException e) {
            throw new SQLException("Could not instantiate class: " + statement_class);
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Could not access class: " + statement_class);
        }
        statement.init(connection, statement_tree, query);
        statement.resolveTree();
        statement.prepare();
        Table result = statement.evaluate();
        return result;
    }
}

